//
//  MCActivityView.h
//  MCApplication
//
//  Created by Ali Lalani on 2/5/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCStackResultsTab.h"

@class MCArrayController,MCActivityTypeChooser,MCTableView,MCGenericPlaceholderView,MCSearchField,MCDateRange;
@class MCToggleButtonBar,MCTVSummaryToolbarView,MCSplitView;

@interface MCActivityView : MCStackResultsTab {
	IBOutlet MCArrayController     *activityController;
	IBOutlet MCActivityTypeChooser *chooser;
	IBOutlet MCSplitView           *splitView;
	IBOutlet NSView                *infoPanelContainerView;
	IBOutlet MCTableView           *tableView;
	IBOutlet MCSearchField         *searchField;
	IBOutlet NSTextField           *descriptionField;
	IBOutlet NSPopUpButton         *dateRangePop;
	IBOutlet NSPopUpButton         *activityTypeChooser;
	IBOutlet MCTVSummaryToolbarView *summaryToolbarView;

	/// ACTIVITY TYPE TABLE
	IBOutlet MCToggleButtonBar     *activityToggle;
	
	MCGenericPlaceholderView *infoPanelPlaceholderView; 

	NSString *_entityName;   // entity name for what is represented here
	
	MCDateRange *dateRange;

	NSMutableDictionary *infoPanelViews; // per entity

	BOOL _splitViewStateRead;
}
- (void)configureActivityTypeChooserWithButtons:(NSArray *)buttons buttonGroups:(NSArray *)buttonGroups;
- (void)configureActivityTypeChooserForImages:(BOOL)flag;

- (IBAction)activityChooserDidAct:(id)sender;

- (IBAction)toggleInfoPanel:(id)sender;
- (IBAction)dateRangePopActed:(id)sender;
- (IBAction)activityToggleDidAct:(id)sender;

- (void)configureWithDictionary:(NSDictionary *)dict;
- (void)configureInfoPanelViewsFromArray:(NSArray *)array;

- (void)setupDateRange;
- (void)fetchActivities;

- (void)updateInfoPanel;

- (NSArray *)activeEntityClassnames;

- (NSString *)entityName;
- (void)setEntityName:(NSString *)anEntityName;

- (MCDateRange *)dateRange;
- (void)setDateRange:(MCDateRange *)aDateRange;

- (NSMutableDictionary *)infoPanelViews;
- (void)setInfoPanelViews:(NSMutableDictionary *)anInfoPanelViews;

- (MCGenericPlaceholderView *)infoPanelPlaceholderView;
- (void)setInfoPanelPlaceholderView:(MCGenericPlaceholderView *)aPlaceholderView;


#pragma mark DisplayStateReadWrite
- (void)readDateRangePopFromDisplayState;
- (void)writeDateRangePopToDisplayState;
- (void)readActivityTypeSelectionFromDisplayState;
- (void)writeActivityTypeSelectionToDisplayState;
- (void)writeSplitViewProportionsToDisplayState;
- (void)readSplitViewProportionsFromDisplayState;
@end
